import random, time

RESET = "\033[0m"
TITLE = "\033[96m"
INFO = "\033[90m"
C_INIT = "\033[36m"   # блакитний (початковий масив)
C_SORT = "\033[32m"   # зелений (відсортований масив)

n, amax = 12, 99
a = [random.randint(1, amax) for _ in range(n)]

def show_bars(arr, color, title):
    m = max(arr)
    scale = max(1, m // 25)
    print(TITLE + title + RESET)
    for v in arr:
        bar = "█" * (v // scale)
        print(f"{color}{v:3} | {bar}{RESET}")
    print("-" * 40)

def bubble(arr, rev=False):
    a = arr[:]
    for i in range(len(a) - 1):
        for j in range(len(a) - 1 - i):
            if (a[j] > a[j+1]) != rev:
                a[j], a[j+1] = a[j+1], a[j]
    return a

def insertion(arr, rev=False):
    a = arr[:]
    for i in range(1, len(a)):
        k = a[i]
        j = i - 1
        while j >= 0 and ((a[j] > k) != rev):
            a[j+1] = a[j]
            j -= 1
        a[j+1] = k
    return a

print(TITLE + "Порівняння алгоритмів сортування" + RESET)
print("Початковий масив:", a)
show_bars(a, C_INIT, "Початковий вигляд масиву")

print("Оберіть алгоритм:")
print("1 – Бульбашкове сортування")
print("2 – Сортування вставками")
alg = input("Ваш вибір (1/2): ").strip()

print("Оберіть напрям:")
print("1 – за зростанням")
print("2 – за спаданням")
rev = (input("Ваш вибір (1/2): ").strip() == "2")

start = time.time()
if alg == "2":
    res = insertion(a, rev)
    name = "Сортування вставками"
else:
    res = bubble(a, rev)
    name = "Бульбашкове сортування"
t = time.time() - start

direction = "спадання" if rev else "зростання"
print(INFO + f"Алгоритм: {name}, напрям: {direction}" + RESET)
show_bars(res, C_SORT, "Відсортований масив")
print(INFO + f"Час виконання: {t:.6f} c" + RESET)
print(INFO + "Перевірка sorted(): " + RESET, sorted(a, reverse=rev))
