import random

COLORS = [
    "\033[31m", "\033[32m", "\033[33m",
    "\033[34m", "\033[35m", "\033[36m",
]
RESET = "\033[0m"
TITLE = "\033[96m"
INFO = "\033[90m"
C_LEFT = "\033[91m"   # лівий елемент у порівнянні
C_RIGHT = "\033[92m"  # правий елемент у порівнянні

n, amax = 8, 40
a = [random.randint(1, amax) for _ in range(n)]

def color_for_index(idx):
    return COLORS[idx % len(COLORS)]

def show_array_line(arr, i=-1, j=-1, note=""):
    m = max(arr)
    scale = max(1, m // 10)

    if note:
        print(TITLE + note + RESET)

    print(INFO + "Індекси: " + " ".join(f"{k:3}" for k in range(len(arr))) + RESET)
    print("Значення:", " ".join(f"{v:3}" for v in arr))
    print("Стовпчики:")
    for idx, val in enumerate(arr):
        base_color = color_for_index(idx)
        if idx == i:
            color = C_LEFT
        elif idx == j:
            color = C_RIGHT
        else:
            color = base_color
        bar = "█" * (val // scale)
        print(f"{color}{bar:8}{RESET}", end=" ")
    print("\n" + "-" * 60)

print(TITLE + "Бульбашкове сортування (bubble sort)" + RESET)
show_array_line(a, note="Початковий стан масиву")
input(INFO + "Enter → почати сортування..." + RESET)

for i in range(len(a) - 1):
    swapped = False
    print(TITLE + f"Прохід {i + 1}" + RESET)
    for j in range(len(a) - 1 - i):
        show_array_line(a, i=j, j=j+1, note=f"Порівнюємо елементи з індексами {j} і {j+1}")
        if a[j] > a[j + 1]:
            print("\033[91mОбмін елементів\033[0m")
            a[j], a[j + 1] = a[j + 1], a[j]
            swapped = True
            show_array_line(a, i=j, j=j+1, note="Після обміну")
        else:
            print("\033[92mОбмін не потрібен\033[0m")
        input(INFO + "Enter → наступний крок..." + RESET)

    if not swapped:
        print("\033[92mМасив уже впорядкований. Дострокове завершення.\033[0m")
        break

print(TITLE + "Результат сортування:" + RESET, a)
show_array_line(a, note="Фінальний вигляд масиву")
