import random

# Кольори ANSI
COLORS = [
    "\033[31m",  # червоний
    "\033[32m",  # зелений
    "\033[33m",  # жовтий
    "\033[34m",  # синій
    "\033[35m",  # пурпурний
    "\033[36m",  # блакитний
]
RESET = "\033[0m"
TITLE = "\033[96m"   # бірюзовий для заголовків
INFO = "\033[90m"    # сірий для службових повідомлень
H_MIN = "\033[91m"   # яскраво-червоний (мінімум на кроці)
H_I = "\033[92m"     # яскраво-зелений (поточна позиція)

n, amax = 10, 50
a = [random.randint(1, amax) for _ in range(n)]

def color_for_index(idx):
    """Повертає колір для елемента з індексом idx (циклічно)."""
    return COLORS[idx % len(COLORS)]

def show_array(arr, i=-1, min_i=-1, title=""):
    """Текстова «діаграма» з різнокольоровими стовпчиками."""
    if title:
        print(TITLE + title + RESET)
    m = max(arr)
    scale = max(1, m // 20)

    print(INFO + "Індекси: " + " ".join(f"{k:3}" for k in range(len(arr))) + RESET)
    print("Значення:", " ".join(f"{v:3}" for v in arr))
    print("Діаграма:")

    for idx, val in enumerate(arr):
        base_color = color_for_index(idx)
        if idx == i:
            color = H_I
        elif idx == min_i:
            color = H_MIN
        else:
            color = base_color
        bar = "█" * (val // scale)
        print(f"{color}{val:3} | {bar}{RESET}")
    print("-" * 40)

print(TITLE + "Сортування вибором (selection sort)" + RESET)
print("Початковий масив:", a)
show_array(a, title="Стартовий стан масиву")

for i in range(len(a) - 1):
    min_i = i
    for j in range(i + 1, len(a)):
        if a[j] < a[min_i]:
            min_i = j
    a[i], a[min_i] = a[min_i], a[i]
    show_array(a, i=i, min_i=min_i, title=f"Крок {i + 1}: мінімум перенесено на позицію {i}")

print(TITLE + "Результат сортування:" + RESET, a)
show_array(a, title="Фінальний вигляд масиву")
